//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "PPSaver_PropertiesSetProgrammatically_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Ppsaver"
#pragma resource "*.dfm"

TForm1 *Form1;
const char* CLSID_DivX = "{78766964-0000-0010-8000-00AA00389B71}";
unsigned int DIVX_V52_INTERFACE_VERSION = 3125745154;
const char* DIVX_FILMEFFECT_ID = "017011";


//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnActivateClick(TObject *Sender)
{
   IUnknown *pUnk;

   // if "Call to undefined function StringToGUID" error, simply recompile the project
   if (CoCreateInstance(StringToGUID (CLSID_DivX), NULL, CLSCTX_INPROC_SERVER || CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **) &pUnk) == S_OK ) {
      if (PropertyPageSaver->Activate(pUnk)) {
         if (PropertyPageSaver->GetInterfaceVersion() == DIVX_V52_INTERFACE_VERSION) {
            PropertyPageSaver->RestoreProperties();
            btnActivate->Enabled = False;
            btnDialog->Enabled = True;
            btnDeactivate->Enabled = True;
            tbrFilmEffect->Position = StrToIntDef (PropertyPageSaver->GetProperty (DIVX_FILMEFFECT_ID), 0);
         }
         else {
            mmoResults->Lines->Add ("Interface version error: DivX v5.2 required");
         }
      }
      pUnk->Release();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnDialogClick(TObject *Sender)
{
   if (PropertyPageSaver->ShowDialog()) { // button OK pressed
      PropertyPageSaver->SaveProperties();
   }
   tbrFilmEffect->Position = StrToIntDef (PropertyPageSaver->GetProperty (DIVX_FILMEFFECT_ID), 0); // we refresh the trackbar
}
//---------------------------------------------------------------------------

void __fastcall TForm1::tbrFilmEffectChange(TObject *Sender)
{
   PropertyPageSaver->SetProperty (DIVX_FILMEFFECT_ID, IntToStr (tbrFilmEffect->Position));

}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnDeactivateClick(TObject *Sender)
{
   PropertyPageSaver->SaveProperties();
   PropertyPageSaver->Deactivate();
   btnActivate->Enabled = True;
   btnDialog->Enabled = False;
   btnDeactivate->Enabled = False;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnShowGlobalClick(TObject *Sender)
{
   IUnknown *pUnk;

   if (CoCreateInstance(StringToGUID (CLSID_DivX), NULL, CLSCTX_INPROC_SERVER || CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **) &pUnk) == S_OK ) {
      if (PropertyPageSaver->Activate(pUnk)) {
         mmoResults->Text = PropertyPageSaver->GetPropertiesState();
         mmoResults->Lines->Add ("");
         PropertyPageSaver->Deactivate();
      }
      pUnk->Release();
   }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnShowIdentificationClick(TObject *Sender)
{
   IUnknown *pUnk;

   if (CoCreateInstance(StringToGUID (CLSID_DivX), NULL, CLSCTX_INPROC_SERVER || CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **) &pUnk) == S_OK ) {
      if (PropertyPageSaver->Activate(pUnk)) {
         PropertyPageSaver->IdentifyProperties = True; // to show the "IDENTIFY" tab in the dialog
         PropertyPageSaver->ShowDialog();
         PropertyPageSaver->Deactivate();
      }
      pUnk->Release();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PropertyPageSaverPropertiesRestored(
      TObject *Sender)
{
   StatusBar1->SimpleText = "Properties restored from: " + PropertyPageSaver->GetFullRegistryPath();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PropertyPageSaverPropertiesSaved(TObject *Sender)
{
   StatusBar1->SimpleText = "Properties saved at: " + PropertyPageSaver->GetFullRegistryPath();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TabSheet3Show(TObject *Sender)
{
   tbrFilmEffect->Position = StrToIntDef (PropertyPageSaver->GetProperty (DIVX_FILMEFFECT_ID), 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PropertyPageSaverNewPropertyValue(TObject *Sender,
      AnsiString PropertyId, AnsiString PropertyValue,
      AnsiString PropertyLabel)
{
   if (! PropertyPageSaver->IdentifyProperties) { // we do not display it if we identify through the dialog to avoid confusing
      mmoResults->Lines->Add (PropertyId + " = " + PropertyValue  + "  (" + PropertyLabel + ")");
   }
}
//---------------------------------------------------------------------------


